#include <graphics.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#include <string.h>
#include <conio.h>
#include  <math.h>
#include  <fcntl.h>
#include <io.h>
#include <bios.h>
#include <alloc.h>
#include <values.h>
#include  "keycodes.h"
#include  "main.h"
#include  "ipicthmp.h"

void displ_txt(Menu_Type *mn),rezult(int ch),displ_instr(Menu_Type *mn),
      coord_menu(Menu_Type *mn);
void displ_page(char *buf,int n,int lstr);

int PrnReady(void);

Menu_Type gmenu={"gmenu",3,0,0,0,0,13,16,46,7,0,25,14},
	  imenu={"imenu",2,0,0,0,0,3,10,46,6,0,25,14},
	  fmenu={"fmenu",2,0,0,0,0,23,5,46,6,0,25,14},
	  instr={"instr",0,0,0,0,0,8,2,46,17,0,0,0};

void *pointer,*lamp_on,*lamp_off,*handle_on,*handle_off,
	    *ret_on,*ret_off,*swt_left,*swt_right;

float system_time=0,mean_vr,specific_catch;
void *bufptr;

/*********************************************************************/
/*main()                                                             */
/*********************************************************************/
main(int argc,char **argv)
{
char pcximage1[] = "NDU2.PCX";
char pcximage2[] = "NDU22.PCX";
int regim=TREN;
double period;

if(!strcmp(argv[1],"test"))
   {
   regim=TEST;
   period=atof(argv[2]);
   }
init_gr();
init_data();
hump_pcx(pcximage2,1);
hump_pcx(pcximage1,0);
read_image();
coord_menu(&gmenu);
coord_menu(&imenu);
coord_menu(&fmenu);
coord_menu(&instr);
while(1)
   {
   switch(menu(&gmenu))
       {
       case INSTRUCT:
	   displ_txt(&instr);
	   displ_instr(&instr);
/*	   getch();*/
	   hump_pcx(pcximage1,0);
	   break;
       case WORK:
	   work(regim,period);
       case ESC:
       default:
	   textmode(C80);
	   clrscr();
//	   exit(0);
//	   closegraph();
	   fcloseall();
	   return;
       }
   } /*while*/
} /* main */
/********************************************************************/
/* choice_menu */
/********************************************************************/
choice_menu(Menu_Type *mn)
{
int i=1,j;
while(1)
   {
   j=i;
   putimage(mn->xl+mn->ofsx,mn->yl+mn->ofsy+(i-1)*DY_FONT,pointer,XOR_PUT);
   switch(getkey())
       {
       case UPKEY :
	   if (i>1)
	       i--;
	   break;
       case DOWNKEY :
	   if (i<mn->num_target)
	       i++;
	   break;
       case CR:
	   return(i);
       case ESC:
	   return(ESC);
       default :
	   break;
       } /* switch */
   putimage(mn->xl+mn->ofsx,mn->yl+mn->ofsy+(j-1)*DY_FONT,pointer,XOR_PUT);
   }
}/* choice_menu */
/********************************************************************/
/*  displ_txt() */
/********************************************************************/
void displ_txt(Menu_Type *mn)
{
char *buf;
int fd,n=2*mn->row*mn->col;

directvideo=0;
buf=malloc(n);
fd=open(mn->namef,O_RDONLY | O_BINARY);
read(fd,buf,n);
close(fd);
puttext(mn->x,mn->y,mn->x+mn->col-1,mn->y+mn->row-1,buf);
free(buf);
}/*  displ_txt */
/********************************************************************/
/*  displ_instr */
/********************************************************************/
void displ_instr(Menu_Type *mn)
{
char *buf;
int j=0,c,lstr=mn->col-2,num_str=30,point=0,page=mn->row-5;
FILE *in;

buf=malloc((lstr+1)*num_str);
in=fopen("trener.doc","r");
while(!feof(in))
   {
   fgets(buf+j,lstr,in);
   j+=lstr;
   }
fclose(in);
window(mn->x+2,mn->y+2,mn->x+mn->col-3,mn->y+mn->row-2);
displ_page(buf,page,lstr);
do
   {
   switch(c=getkey())
       {
       case UPKEY:
	   if (point)
	       {
	       point-=page;
	       if (point<0)
		   point=0;
	       displ_page(buf+point*lstr,page,lstr);
	       }
	   break;
       case DOWNKEY:
	   j=point+page;
	   if(j<num_str)
	       {              
	       point=j;
	       j=num_str-point;
	       displ_page(buf + point*lstr,page,lstr);
/*	       displ_page(buf + point*lstr,j>page ? page :j,lstr);*/

	       }
	   break;
	default:
	   break;
       } /* switch */
   }
while(c!=ESC);
window(1,1,80,25);
free(buf);
} /* displ_instr */
/********************************************************************/
/* displ_page                                                       */
/********************************************************************/
void displ_page(char *buf,int n,int lstr)
{
char *pt=buf;
int i,j,y=1,ch,fl=0,ls=lstr-2;
for(i=0;i<n;i++)
   {
   j=0;
   gotoxy(1,y++);
   while((ch=*(pt+j))!='\n' && j<ls && fl==0)
       {
       if(ch=='#')
	   {
	   fl=1;
	   break;
	   }
       else
	   putch(ch);
       j++;
       }
   while(j++<ls)
       putch(32);
   if(!fl)
       pt+=lstr;
   }
}/* displ_page */

/********************************************************************/
/*  menu() */
/********************************************************************/
int menu(Menu_Type *mn)
{
int c=0;
/*   printf("the top of the heap is: %lu bytes\n",  farcoreleft());*/
if((bufptr=malloc(mn->size))==NULL)
   {
   puts("nomemory");
   exit(0);
   }
getimage(mn->xl,mn->yl,mn->xr,mn->yr,bufptr);
displ_txt(mn);
if(mn->num_target)
   c=choice_menu(mn);
else getch();
putimage(mn->xl,mn->yl,bufptr,0);
free(bufptr);
return (c);
}/* menu */
/********************************************************************/
/*  rezult() */
/********************************************************************/
void rezult(int ch)
{
int i=0,j;
float calc_vr=0,grad_vr[]={1,1.4,1.7,MAXFLOAT};
char *text_rez[]={"㤮⢮⥫","","㤮⢮⥫",
		   "訥"};
FILE *out;
if(mean_vr)
   calc_vr=1/(KOEFF1/mean_vr+KOEFF2*specific_catch);
while(calc_vr>grad_vr[i])  i++;
if(ch==ESC)   j=-1;
else          j=i;
out=fopen("op.txt","w");
fprintf(out,"%d\n",j);
fprintf(out,"। ᪮ ᪠  %2.2f /\n",mean_vr);
fprintf(out," ᪮ %1.3f\n",specific_catch);
fprintf(out,"१ %s\n",text_rez[i]);
fclose(out);
} /*  rezult */

/********************************************************************/
/*   print_rez	                    	    */
/********************************************************************/
int print_rez(void)
{
FILE *in,*out;
char buf[81];
if (!PrnReady())
   return 0;
in=fopen("op.txt","r");
out=fopen("prn","w");
fgets(buf,80,in);
while(!feof(in))
   {
   fgets(buf,80,in);
   fputs(buf,out);
   *buf=0;
   }
fclose(in);
fclose(out);
return 1;
} /*  print_rez */

/********************************************************************/
/*  coord_menu */
/********************************************************************/
void coord_menu(Menu_Type *mn)
{
mn->xl=(mn->x-1)*DX_FONT;
mn->yl=(mn->y-1)*DY_FONT;
mn->xr=mn->xl+mn->col*DX_FONT;
mn->yr=mn->yl+mn->row*DY_FONT;
mn->size=imagesize(mn->xl,mn->yl,mn->xr,mn->yr);
}/* coord_menu */

/**************************************************************/
/* PrnReady()  ஢ઠ ⮢                      */
/**************************************************************/
int PrnReady(void)
{
/*static char *erprn[]={" ⮢ 饥 ன⢮!"};
static char *noprn[]={"⪠   -  ESC"};*/

while(1)
   {
   if(biosprint( STATUS_PRN,0,PORTNUM) &  ERRPRN)
       {
       if( getch()==ESC)
	   return(0);
       }
   else return(1);
   }
}  /* PrnReady */
