#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include  <math.h>
#include  "icuttype.h"
#include  "keycodes.h"
#include  "humptype.h"
#include  "main.h"

#define         MAX_SWITCH      1/*६,    "hump_ndu.h"*/

// #define	DELTA_T          0.2

float gradient(bool lp,float ds,byte nw);
float grad_ax(byte i,float ds,float *wrw,float *wrn,float *hsc,bool lp,
              byte nw);
float resist_wind(void);
byte power(int a,float d,float *ei,float *wrw,float *wrn,float *hsc,byte i);

void forid(byte i),step_cut(void),copy_axis(void);

extern CutType       c[20];
extern float point_sep,ht[],resist[],sfin,vrosp,v_wind,beta;
extern int buf_cut[];
extern HumpType h[];
extern SwitchType swtc[];
extern byte type_chain[],adr_chain[],ic;
extern float part2_ds[],t_response[];
extern PosRetType  posret[];

/*********************************************************************/
/* forid() - ନ஢  楯                              */
/*********************************************************************/
void forid(byte i)
{
static float d[]={1.71,1.85,6.8,1.85,1.71,                 /* -4 */
	   1.44,1.85,8.15,1.85,1.44,                       /* -4 */
	   1.525,1.85,7.87,1.85,1.525,                     /* -4 */
	   1.185,1.85,5.95,1.85,1.185,                     /* -4 */
	   1.23,1.75,1.75,6.94,1.75,1.75,1.23,             /* -6 */
	   1.56,1.85,1.35,1.85,7.02,1.85,1.35,1.85,1.56};  /* -8 */
static float b[]={34.6,40,38.88,31.2,41.76,96.56};
static float avto[]={0.61,0.43,0.61,0.61,0.61,0.565};
static byte m1[]={0,5,10,15,20,27,36};

byte type,beg,end,j,k;
float x;
/***********************************************************************/
/*樠   ० ᪠뢠*/ 
c[i].beta=beta;
c[i].v_wind=v_wind;
c[i].v0=vrosp;
/************************************************************************/
c[i].weight=0;
c[i].length=0;
c[i].quant_axis=0;
for(j=0;j<c[i].quant_car;j++)
   c[i].weight+=c[i].twl_cut.weight_car[j];
x=1/c[i].weight;
for(j=0;j<c[i].quant_car;j++)
   {
   type=c[i].twl_cut.type_car[j]-1;
   c[i].body[2*j]=-(c[i].length+avto[type]);
   c[i].twl_cut.load_car[j]=x*c[i].twl_cut.weight_car[j]/b[type];
   beg=m1[type];end=m1[type+1];
   for(k=beg;k<end;k++)
       {
       c[i].length+=d[k];
       c[i].model_axis_main.delta[c[i].quant_axis]=c[i].length;
       if(k<end-1)
	   c[i].quant_axis++;
       }
   c[i].body[2*j+1]=avto[type]-c[i].length;
   }
x=c[i].model_axis_main.delta[0];
c[i].l_front=x;
c[i].l_back=d[k-1];
for(j=0;j<c[i].quant_axis;j++)
   {
   c[i].model_axis_main.delta[j]-=x;
   c[i].model_axis_main.num_element[j]=0;
   }
c[i].base=c[i].model_axis_main.delta[j-1];
c[i].g1=0.00981/(1+0.42*c[i].quant_axis/c[i].weight);
x=c[i].beta*0.017453;
c[i].ysw=fabs(c[i].v_wind*sin(x));
c[i].ysw1=c[i].ysw*c[i].ysw;
c[i].ysw2=c[i].v_wind*cos(x);
c[i].ysw3=0.067/c[i].weight;
c[i].ey1=0;c[i].ey2=0;
c[i].status=SOSTAW;
c[i].sf=sfin+c[i].length;
}      /* forid  */
/*********************************************************************/
/* step_cut -  ६饭  楯  DELTA_T                     */
/*********************************************************************/
#define	       EPS_DS	0.1
void step_cut(void)
{
float wsw,dsr,ieq,dsf, dsv,t,dt=DELTA_T,dsa=0,acceler;
register j;
dsv=dt*c[ic].vj;
dsr=dsv+dsa;
//wsw=resist_wind(ic);
wsw=resist_wind();
do
   {
   for(j=0;j<2;j++)
       {
       type_chain[j]=0;
       adr_chain[j]=0;
       part2_ds[j]=0;
       }
   ieq=gradient(FALSE,dsr,0xff); /*  ६饭 */
   acceler=(ieq-c[ic].w0-wsw)*c[ic].g1;
   if(buf_cut[ic]==1)
/*   printf(" %d ieq=%f wsw=%f ac=%f \n ",buf_cut[ic],ieq,wsw,acceler);
  */ dsa=acceler*dt*dt/2;
   dsf=dsv + dsa;
   if(fabs( dsf-dsr)<EPS_DS)
       break;
   dsr=dsf;
   }
while(1);
c[ic].vj+=acceler*dt;
c[ic].tj+=dt;
c[ic].sj+=dsf;
c[ic].ds=dsf;
c[ic].ey2=c[ic].ey1;
//copy_axis(ic);	                     /* 䨪a ६饭   main*/
copy_axis();	                     /* 䨪a ६饭   main*/
for(j=0;j<2;j++)
   {
   if (type_chain[j] && (c[ic].adr_chain[j]!=adr_chain[j]))
       {
       t=c[ic].tj-part2_ds[j]*dt/dsf;
       if (type_chain[j] & 1)
	   swtc[adr_chain[j]-1].chain.t[j]=t+t_response[j];
       else
	   posret[adr_chain[j]-1].chain.t[j]=t+.5;
       c[ic].type_chain[j]=type_chain[j];
       }
   c[ic].adr_chain[j]=adr_chain[j];
   }
}/* step_cut  */
/*********************************************************************/
/* gradient -   㪫  ६饭  楯  ds            */
/*********************************************************************/
#define SIX      3
#define SIX_1    2
#define SIX_2    5
float gradient(bool lp,float ds,byte nw)
{
float e=0,ej,ei,ey,x,wrw_car,wrw_cut=0,wrw,wrn=0,hsc=0,sumw=0;
byte ax_type[]={4,4,4,4,6,8};
byte i=0,j,k,axis2,axis;
if(ds)
   {
for(j=0;j<c[ic].quant_car;j++)
   {
   axis=ax_type[c[ic].twl_cut.type_car[j]-1];
   ej=0;
   axis2=axis/2;
   wrw_car=0;
   for(k=0;k<axis;k++)
       {
       ei=grad_ax(i,ds,&wrw,&wrn,&hsc,lp, nw);
       wrw_car+=wrw;
       if(axis2==SIX)
	   {
	   if(k==SIX_1 ||k==SIX_2 )
	       x=.854;
	   else
	       x=.573;
	   ei*=x;
	   }
       if(k<axis2)
	   ei=-ei;
       ej+=ei;
       i++;
       }
   wrw_cut+=wrw_car*c[ic].twl_cut.weight_car[j]/axis;
   e+=ej*c[ic].twl_cut.load_car[j];
   }
sumw=(wrw_cut/c[ic].weight+(wrn+hsc*c[ic].vj*c[ic].vj)/c[ic].quant_axis)/ds;
   }
ey=c[ic].ey2-e;
c[ic].ey1=ey-e;
if(lp)
   c[ic].ey2=c[ic].ey1;
return(ey-sumw);
}/* gradient  */
/*********************************************************************/
/* resist_wind() -   ᮯ⨢ ।                 */
/*********************************************************************/
float resist_wind(void)
{
/*float  cx[]={11.56,4.25,10.86,2.13,6.19,1.86,
	      5.78,1.74,14.89,5.10,16.69,8.02},
       cxx[]={1.56,2.06,1.97,3.97,2.12,3.12,
	      2.33,3.33,1.20,2.25,1.65,1.86},
       cxxx[]={2.05,1.78,2.52,3.02,2.63,2.61,
	      2.66,2.65,1.68,1.83,2.27,1.94};*/
float wsw,sum_v,sum_cx=0,alpha,vr_sqr;
byte k,k1,k2;
sum_v=c[ic].ysw2+c[ic].vj;
vr_sqr=c[ic].ysw1+sum_v*sum_v;
#if 0
alpha=asin(c[ic].ysw/sqrt(vr_sqr));
for( k1=0,k2=0;k2<c[ic].quant_car;k2++)
   {
   k=(c[ic].twl_cut.type_car[k2]-1)*2+k1;
   sum_cx+=cx[k]*exp((cxx[k]-alpha*cxxx[k])*alpha);
   k1=1;
   }
#endif
sum_cx=11.2;
wsw=c[ic].ysw3*vr_sqr*sum_cx;
return(sum_v<0 ? -wsw:wsw);
}/* resist_wind */

/*********************************************************************/
/* grad_ax() -   㪫  ६饭   楯  ds       */
/*********************************************************************/
float grad_ax(byte i,float ds,float *wrw,float *wrn,
	      float *hsc,bool lp,byte nw)
{
float ei=0,d,r,rest;
int a;
byte pos,m;
*wrw=0;
a=c[ic].model_axis_main.num_element[i];
d=c[ic].model_axis_main.delta[i];
rest=d-ds;
if(rest<0)
   {
   do
       {
       r=rest;
       if(power(a,d,&ei,wrw,wrn,hsc,i)==POST_SWITCH )
	   {
	   m=h[a].adr-1;
	   if(nw!=0xff)
	       /*ᤢ 1   n,
	       ⮡ 뤥    ॡ㥬  ५*/
	       pos=nw & 1<<(MAX_SWITCH-swtc[m].pos & 0x0f);
	   else
	       pos=swtc[m].pos & 0x80;
	   if(pos)
	       a=swtc[m].right;
	   else
	       a=swtc[m].left;
	   }
       else
	   a++;
       d=h[a].len;
       rest=r+d;
       }
   while(rest<0);
   ds=fabs(r);
   }
power(a,ds,&ei,wrw,wrn,hsc,i);
if(lp==TRUE)
   {
   c[ic].model_axis_main.num_element[i]=a;
   c[ic].model_axis_main.delta[i]=rest;
   }
else
   {
   c[ic].model_axis_work.num_element[i]=a;
   c[ic].model_axis_work.delta[i]=rest;
   }
return(ei);
}/* grad_ax */

/*********************************************************************/
/* power() -   㪫  ᮯ⨢    ﭨ d  */
/*********************************************************************/
byte power(int a,float d,float *ei,float *wrw,float *wrn,float *hsc,
	   byte i)
{
byte k,ad,upr,res;
k=h[a].type;
ad=h[a].adr;
upr=k & '\17';
if((res=k>>4)!=0)
   *hsc+=d*resist[res-1];
if(upr==WEIGHT_RET)
   *wrw+=ht[ad-1]*d;
else if(upr==NOWEIGHT_RET)
   *wrn+=ht[ad-1]*d;
*ei+=d*h[a].grad;
if(!i)
   {
   if(upr==PRED_RET || upr==PRED_SWITCH)
       {
       adr_chain[0]=ad;
       type_chain[0]=upr;
       }
   if(type_chain[0])
       part2_ds[0]+=d;
   }
else if(i==c[ic].quant_axis-1)
   {
   if(upr==POST_RET || upr==POST_SWITCH)
       {
       adr_chain[1]=ad;
       type_chain[1]=upr;
       }
   else if(type_chain[1])
       part2_ds[1]+=d;
   }
return(upr);
}  /* power */

/*********************************************************************/
/* copy_axis() -  뫪 ᥢ       */
/*********************************************************************/
void copy_axis(void)
{
register j;
int *pdn,*psn ;
float *pdd,*psd;
pdd=c[ic].model_axis_main.delta;
psd=c[ic].model_axis_work.delta;
pdn=c[ic].model_axis_main.num_element;
psn=c[ic].model_axis_work.num_element;

for(j=0;j<c[ic].quant_axis;j++)
   {
   *pdd++=*psd++;
   *pdn++=*psn++;
   }
}/* copy_axis */